import random
import math

# abstract class used to specify interface
class Range:
    # ABSTRACT: intializes the measurement range with its required data
    # return type: self
    def __init__(self):
        raise Exception("Range initialization is not defined")
        # returns type: self
    
    # ABSTRACT: moves the sensor to the desired theta location
    # returns type: None
    def moveToTheta(self):
        raise Exception("Range moveToTheta is not defined")

    # ABSTRACT: moves the sensor to the desired phi location
    # returns type: None
    def moveToPhi(self):
        raise Exception("Range moveToPhi is not defined")

    # ABSTRACT: programs the array MG state
    # returns type: None
    def programState(self):
        raise Exception("Range programState is not defined")
    
    # ABSTRACT: programs the array phase settings
    # returns type: None
    def programPhases(self):
        raise Exception("Range programState is not defined")

    # ABSTRACT: optimizes the phase settings for the given state and sensor location
    # returns type: phase settings
    def oprtimizePhase(self):
        raise Exception("Range optimizePhase is not defined")

    # ABSTRACT: measure the sensor location
    # returns type: measurement Data
    def measure(self):
        raise Exception("Range Measure is not defined")

# this range is a working default that doesn't do anything
# used for testing code
class EmptyRange(Range):
    # random: should data be a random number or always 1
    def __init__(self, random = False, verbose=False):
        self.theta = 0
        self.phi = 0
        self.state = 0
        self.verbose = verbose
        self.random = random

    def moveToTheta(self, theta):
        self.theta = theta
        if self.verbose:
            print "moving to position", theta

    def moveToPhi(self, phi):
        self.phi = phi
        if self.verbose:
            print "moving to position", phi

    def programState(self,state):
        self.state = state
        if self.verbose:
            print "programming state: ",state

    def programPhases(self,phases):
        if self.verbose:
            print "programming phases: ",phases

    def optimizePhase(self):
        if self.verbose:
            print "Optimizing Phases"
        return [360*random.random() for i in range(25)]

    def measure(self):
        if self.random:
            data = random.random()    
        else:
            sl_weight = self.state/(2.0**24)
            data = 10*math.log10(10**-10 + (1-sl_weight)*abs(math.cos(self.theta * math.pi/180.0))**5 + sl_weight*abs(math.sin(self.theta * math.pi/180.))**5)
        if self.verbose:
            print "Measured data:", data
        return data

